/**
 * Klasse VideoPlayer
 * Video Player der Videos anzeigt
 *
 * 1.1.1    2023-08-03  Markus Ehring
 *          -BugFix Fehler wodurch nur eine VideoPlayer-Instanz pro Whiteboard moeglich war behoben
 *          -Fix Steuerbuttons der VideoPlayer haben jetzt nicht mehr identische IDs
 *
 *
 * @constructor
 * @param {float} pPosX Position.x des PLayers
 * @param {float} pPosY Position.y des Players
 * @param {float} pWidth Breite des Players
 * @param {float} pHeight Höhe des Players
 * @param {string} pSrc Pfad des Videos
 */
function VideoPlayer(pPosX, pPosY, pWidth, pHeight, pSrc) {
    this.pPosX = pPosX;
    this.pPosY = pPosY;
    this.pWidth = pWidth;
    this.pHeight = pHeight;
    this.pSrc = pSrc;

    /**
     * Erstellt die HTML Elemente
     * @param {jqueryelement} rParent
     */
    this.create = function (rParent) {
        this.rParent = rParent;
        this.rSelector = $("<div class=videoPlayer></div>").appendTo(rParent);
        this.video = $('<video><source src="src/' + this.pSrc + '"></video>');
        $(this.video).css("width", "100%");
        $(this.video).css("height", "100%");
        $(this.video).css("left", 0);
        $(this.video).css("top", 0);
        $(this.video).controls = false;

        // event when rSelector is hidden
        $(this.rSelector).on("hide", function () {
            $(this.video)[0].pause();
        });

        this.rVideo = $(this.video).appendTo(this.rSelector);

        this.btn_play = $("<button class='videoPlayer_btn_play'>PLAY</button>");
        this.btn_pause = $("<button class='videoPlayer_btn_pause'>PAUSE</button>");

        var t = this;
        $(this.video).click(function () {
            if (this.paused) {
                t.play();
            } else {
                t.pause();
            }
        });

        $(this.btn_play).click(function () {
            t.play();
        });

        $(this.btn_pause).click(function () {
            t.pause();
        });

        $(this.btn_play).appendTo(this.rSelector);
        $(this.btn_pause).appendTo(this.rSelector);
        this.pause();
    };

    this.play = function () {
        $(this.video)[0].play();
        $(this.btn_pause).css("background-color", "rgb(190, 226, 249)");
        $(this.btn_play).css("background-color", "rgb(112, 134, 148)");
    };

    this.pause = function () {
        $(this.video)[0].pause();
        $(this.btn_play).css("background-color", "rgb(190, 226, 249)");
        $(this.btn_pause).css("background-color", "rgb(112, 134, 148)");
    };

    /**
     * Setzt die Skalierung
     * @param {float} pScale Skalierung
     */
    this.setScale = function (pScale) {
        this.pScale = pScale;
        $(this.rSelector).css("width", this.pWidth * this.pScale + "px");
        $(this.rSelector).css("height", this.pHeight * this.pScale + "px");
        $(this.rSelector).css("left", this.pPosX * this.pScale + "px");
        $(this.rSelector).css("top", this.pPosY * this.pScale + "px");
    };

    /**
     * Stellt den Lösungszustand her
     */
    this.solve = function () {};

    /**
     * Gibt an ob der Lösungszustand vorliegt
     * @returns {boolean} true falls das Teil richtig geloest ist. Sonst false.
     */
    this.isSolved = function () {
        return this.pSolved;
    };

    /**
     * Setzt das Teil in dessen Ausgangszustand zurück
     */
    this.reset = function () {};

    /**
     * Speichert den Zustand des Teils in einem JSON Objekt
     * @returns {JSON} JSON Objekt
     */
    this.export = function () {
        var obj = {
            pJsonId: this.pJsonId,
            pType: this.pType,
            pCurrentTime: $(this.rVideo)[0].currentTime,
        };

        return obj;
    };

    /**
     * Importiert den Zustand des Teils aus einem JSON Objekt
     * @param {JSON} rObj JSON-Objekt
     */
    this.import = function (rObj) {
        if (rObj.pType == this.pType && rObj.pJsonId == this.pJsonId) {
            $(this.rVideo)[0].currentTime = rObj.pCurrentTime;
            // console.log(rObj.pCurrentTime);
        } else {
        }
    };
}
